unit rd;

interface

uses
  SysUtils, Classes, Controls, Graphics;

type
  TsyWayState=(wsReady, wsDamage, wsRepair);
  TsyWayOptions=set of (woSpali, woBack);
  TsyWay = class(TGraphicControl)
  private
    FKolea: integer;
    FState: TsyWayState;
    ks: integer;
    FOptions: TsyWayOptions;
    procedure SetKolea(const Value: integer);
    procedure SetState(const Value: TsyWayState);
    procedure SetOptions(const Value: TsyWayOptions);
    {   }

  protected
    { "" }
    procedure Paint; override;
  public
    {     Runtime }

    constructor Create(AOwner: TComponent); override;
  published
    {     Designtime}
   property Kolea: integer read FKolea
   write SetKolea;
   property State: TsyWayState read FState write SetState;
   property Options: TsyWayOptions read FOptions write SetOptions;
  end;


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('', [TsyWay]);
end;

{ TsyWay }

constructor TsyWay.Create(AOwner: TComponent);
begin
  inherited;
  Width:=200;
  Height:=20;
  Kolea:=10;
  Cursor:=crHandPoint;
end;

procedure TsyWay.Paint;
var
k: integer;
begin
  inherited;
  with Canvas do
  begin
  if woSpali in FOptions then
  begin
  ks:=ClientWidth div 10; // todo  ,   
  Pen.Color:=clSilver;
  for k:= 0 to ks do
   Polyline([Point(k*10, 0), Point(k*10, ClientHeight)]);

  end;

 case FState of
  wsReady: Pen.Color:=clBlack ;
  wsDamage:Pen.Color:=clFuchsia;
  wsRepair:Pen.Color:=clRed;
 end;
 Polygon([Point(0,3), Point(ClientWidth, 3)]);
 Polygon([Point(0,3+FKolea),
 Point(ClientWidth, 3+FKolea)]);
  end;
end;

procedure TsyWay.SetKolea(const Value: integer);
begin
  FKolea := Value;
  Repaint;
end;

procedure TsyWay.SetOptions(const Value: TsyWayOptions);
begin
  FOptions := Value;
  Repaint;
end;

procedure TsyWay.SetState(const Value: TsyWayState);
begin
  FState := Value;
  Repaint;
end;

end.
